<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\HomeImage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class HomeImageController extends Controller
{
    public function index()
    {
        $siteUrl = URL::to('/');
        
        $homeImages = HomeImage::all()->map(function ($image) use ($siteUrl) {
            $image->uploaded_image = $siteUrl . Storage::url('images/' . $image->uploaded_image);
            return $image;
        });

        return response()->json(['success' => true, 'data' => $homeImages]);
    }
}
