<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\HomeImage;


class HomeImageController extends Controller
{
    public function index()
    {
        $homeImages = HomeImage::all();
        return view('home', compact('homeImages'));
    }

    public function create()
{
    $imageTypes = ['up_next', 'hot_picks', 'slider', 'single_page', 'home_banner', 'new_tc', 'music', 'new_movies', 'first_cam'];
    return view('home_images.create', compact('imageTypes'));
}

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string',
            'image_type' => 'required|string|in:up_next,hot_picks,slider,single_page,home_banner,new_tc,music,new_movies,first_cam',
            'url' => 'required|url',
            'uploaded_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        $imageName = time() . '.' . $request->uploaded_image->extension();
        $request->uploaded_image->move(public_path('images'), $imageName);

        HomeImage::create([
            'title' => $request->title,
            'image_type' => $request->image_type,
            'url' => $request->url,
            'uploaded_image' => $imageName,
        ]);

        return redirect()->route('home_images.index')->with('success', 'Home image created successfully.');
    }

    public function show($id)
    {
        $homeImage = HomeImage::findOrFail($id);
        return view('home_images.show', compact('homeImage'));
    }

    public function edit($id)
    {
        $homeImage = HomeImage::findOrFail($id);
        return view('home_images.edit', compact('homeImage'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string',
            'image_type' => 'required|string|in:up_next,hot_picks,slider,single_page,home_banner,new_tc,music,new_movies,first_cam',
            'url' => 'required|url',
        ]);

        $homeImage = HomeImage::findOrFail($id);

        $homeImage->update([
            'title' => $request->title,
            'image_type' => $request->image_type,
            'url' => $request->url,
        ]);

        return redirect()->route('home_images.index')->with('success', 'Home image updated successfully.');
    }

    public function destroy($id)
    {
        $homeImage = HomeImage::findOrFail($id);
        $homeImage->delete();

        return redirect()->route('home_images.index')->with('success', 'Home image deleted successfully.');
    }
}
