<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHomeImagesTable extends Migration
{
    public function up()
    {
        Schema::create('home_images', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->enum('image_type', ['up_next', 'hot_picks', 'slider', 'single_page', 'home_banner', 'new_tc', 'music', 'new_movies', 'first_cam']);
            $table->string('url');
            $table->string('uploaded_image'); // This column will store the image file name or path
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('home_images');
    }
}
