@extends('layouts.app')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha512-..." crossorigin="anonymous" />

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <span>{{ __('Home Images') }}</span>
                        <a href="{{ route('home_images.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> {{ __('Create New') }}
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Title</th>
                                <th>Image</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($homeImages as $homeImage)
                            <tr>
                                <td>{{ $homeImage->id }}</td>
                                <td>{{ $homeImage->title }}</td>
                                <td><img src="{{ asset('images/' . $homeImage->uploaded_image) }}" alt="Image" width="100"></td>
                                <td>
                                    <a href="{{ route('home_images.edit', $homeImage->id) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-edit"></i> {{ __('Edit') }}
                                    </a>
                                    <form action="{{ route('home_images.destroy', $homeImage->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash"></i> {{ __('Delete') }}
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection