@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Edit Home Image') }}</div>

                <div class="card-body">
                    <form method="POST" action="{{ route('home_images.update', $homeImage->id) }}" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="form-group">
                            <label for="title">{{ __('Title') }}</label>
                            <input id="title" type="text" class="form-control @error('title') is-invalid @enderror" name="title" value="{{ old('title', $homeImage->title) }}" required autofocus>

                            @error('title')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="image_type">{{ __('Image Type') }}</label>
                            <input id="image_type" type="text" class="form-control" name="image_type" value="{{ old('image_type', $homeImage->image_type) }}" required>

                            @error('image_type')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="url">{{ __('URL') }}</label>
                            <input id="url" type="url" class="form-control @error('url') is-invalid @enderror" name="url" value="{{ old('url', $homeImage->url) }}" required>

                            @error('url')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="uploaded_image">{{ __('Image File') }}</label>
                            <input id="uploaded_image" type="file" class="form-control-file @error('uploaded_image') is-invalid @enderror" name="uploaded_image">
                            @if ($homeImage->uploaded_image)
                                <img id="imagePreview" src="{{ asset('images/' . $homeImage->uploaded_image) }}" alt="Image Preview" style="max-width: 300px; display: block; border: 1px solid #ccc; margin-top: 10px;">
                            @else
                                <img id="imagePreview" src="#" alt="Image Preview" style="display: none; max-width: 300px; border: 1px solid #ccc; margin-top: 10px;">
                            @endif

                            @error('uploaded_image')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <button type="submit" class="btn btn-primary">
                            {{ __('Update') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('uploaded_image').addEventListener('change', function(e) {
        var imagePreview = document.getElementById('imagePreview');
        imagePreview.style.display = 'block';
        imagePreview.src = URL.createObjectURL(e.target.files[0]);
    });
</script>
@endsection
