<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeImageController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
// Define resourceful routes for HomeImageController
Route::get('/home', [HomeImageController::class, 'index'])->name('home_images.index');
Route::get('/home_images/create', [HomeImageController::class, 'create'])->name('home_images.create');
Route::post('/home_images', [HomeImageController::class, 'store'])->name('home_images.store');
Route::get('/home_images/{id}', [HomeImageController::class, 'show'])->name('home_images.show');
Route::get('/home_images/{id}/edit', [HomeImageController::class, 'edit'])->name('home_images.edit');
Route::put('/home_images/{id}', [HomeImageController::class, 'update'])->name('home_images.update');
Route::delete('/home_images/{id}', [HomeImageController::class, 'destroy'])->name('home_images.destroy');