<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha512-..." crossorigin="anonymous" />

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <span><?php echo e(__('Home Images')); ?></span>
                        <a href="<?php echo e(route('home_images.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> <?php echo e(__('Create New')); ?>

                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Title</th>
                                <th>Image</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $homeImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $homeImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($homeImage->id); ?></td>
                                <td><?php echo e($homeImage->title); ?></td>
                                <td><img src="<?php echo e(asset('images/' . $homeImage->uploaded_image)); ?>" alt="Image" width="100"></td>
                                <td>
                                    <a href="<?php echo e(route('home_images.edit', $homeImage->id)); ?>" class="btn btn-sm btn-primary">
                                        <i class="fas fa-edit"></i> <?php echo e(__('Edit')); ?>

                                    </a>
                                    <form action="<?php echo e(route('home_images.destroy', $homeImage->id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash"></i> <?php echo e(__('Delete')); ?>

                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projects 2024\MTDB V2\V 2.0.1\Laravel 3.0.0\API\resources\views/home.blade.php ENDPATH**/ ?>